<?php
defined('PF_VERSION') OR exit('Access denied');
class Pf_Plugin_Singleton
{

    static private $object = array();

    static public function categories($type = 1)
    {
        if (isset(self::$object['categories'])) {
            return self::$object['categories'];
        }
        Pf::database()->select('id, category_name, category_parent', 'pf_categories', 'category_type = ?', array($type));
        $data = Pf::database()->fetch_obj_all();
        if (!empty($data)) {
            self::$object['categories'] = $data;
            return self::$object['categories'];
        }
    }

    static public function list_page()
    {
        if (isset(self::$object['list_page'])) {
            return self::$object['list_page'];
        }
        Pf::database()->select('page_url,page_title', 'pf_pages', 'page_status = ?', array(1));
        $data = Pf::database()->fetch_assoc_all();
        if (empty($data)) {
            return;
        }
        $list = array();
        if (!empty($data)) {
            foreach ($data as $item) {
                $list[$item['page_url']] = $item['page_title'];
            }
        }
        self::$object['list_page'] = $list;
        return self::$object['list_page'];
    }

    static public function list_users($conditions, $param, $select = 'pf_users.id as uid,user_name,user_email')
    {
        if (isset(self::$object['list_users'])) {
            return self::$object['list_users'];
        }
        Pf::database()->select($select, 'pf_users', $conditions, $param);
        $data = Pf::database()->fetch_assoc_all();
        if (empty($data)) {
            return;
        }
        $list = array();
        foreach ($data as $item) {
            $list[$item['uid']] = $item['user_name'];
        }
        self::$object['list_users'] = $list;
        return self::$object['list_users'];
    }

}
